function [suppBOUND,loadBOUND,loadBOUNDvals] = GetBCbars(BARS,boundBARS,SUPP,LOAD)
narginchk(3,4)

Nn = max(max(BARS));

% Find the boundary bars which are supported
if (~isempty(SUPP))
%     IsNodeSupported = any(~isnan(SUPP(:,2:3)),2);
    NodeSupport = false(Nn,1);
%     NodeSupport(SUPP(IsNodeSupported,1)) = true;
    NodeSupport(SUPP(:,1)) = true; % Supported nodes have no direction
    
    suppBOUND = all(NodeSupport(BARS(boundBARS,:)),2);
else
    suppBOUND = [];
end

% Find the boundary bars which are loaded (and compute the load)
if (nargin==4 && ~isempty(LOAD))
    IsNodeLoaded = any(LOAD(:,2:3)~=0,2);
    NodeLoaded = false(Nn,1);
    NodeLoaded(LOAD(IsNodeLoaded,1)) = true;
    
    % Check if both nodes are loaded
    loadBOUND = all(NodeLoaded(BARS(boundBARS,:)),2);
    loadBOUND_ij = BARS(boundBARS(loadBOUND),:);

    NodeLoads = [accumarray(LOAD(:,1),LOAD(:,2),[Nn 1]) accumarray(LOAD(:,1),LOAD(:,3),[Nn 1])];
    loadBOUNDvals = [mean([NodeLoads(loadBOUND_ij(:,1),1) NodeLoads(loadBOUND_ij(:,2),1)],2)...
                     mean([NodeLoads(loadBOUND_ij(:,1),2) NodeLoads(loadBOUND_ij(:,2),2)],2)];
else
    loadBOUND = [];
    loadBOUNDvals = [];
end
return